#!/bin/bash

if [[ "${1}" == "-h" ]] || [[ "${1}" == "--help" ]]; then
	echo "Usage: ${0} /path/to/XCom-Enemy-Unknown"
	echo "Omitting installation path results in using the first existing directory among:"
	echo "~/.local/share/Steam/SteamApps/common/XCom-Enemy-Unknown"
	echo "~/.steam/steamapps/common/XCom-Enemy-Unknown"
	echo "If neither exist, the installation stops and you must specify the path manually"
	echo "Note: This script must be placed in the LWR directory (the one with Config, Localization, etc)"
	exit 0
fi

## get path to LWR dir, assuming this script is placed inside it
source_root="$(dirname "$(readlink -f "${BASH_SOURCE[0]}")")"

## check that this script is placed in the LWR directory
if ! [ -d "${source_root}/Config" ]; then
	echo "ERROR: Cannot find 'Config' directory, make sure the script is placed in the LWR directory"
	exit 1
fi

if ! [ -d "${source_root}/CookedPCConsole" ]; then
	echo "ERROR: Cannot find 'CookedPCConsole' directory, make sure the script is placed in the LWR directory"
	exit 1
fi

if ! [ -d "${source_root}/Localization" ]; then
	echo "ERROR: Cannot find 'Localization' directory, make sure the script is placed in the LWR directory"
	exit 1
fi

## get xcom installation dir
if   [ "${1}" ]; then
	target_root="${1}"
elif [ -d "${HOME}/.local/share/Steam/SteamApps/common/XCom-Enemy-Unknown" ]; then
	target_root="${HOME}/.local/share/Steam/SteamApps/common/XCom-Enemy-Unknown"
elif [ -d "${HOME}/.steam/steamapps/common/XCom-Enemy-Unknown" ]; then
	target_root="${HOME}/.steam/steamapps/common/XCom-Enemy-Unknown"
fi

## check that installation dir exists
if ! [ -d "${target_root}" ]; then
	echo "ERROR: Cannot find XCOM installation directory"
	exit 1
fi

## also check that the feral-interactive dir exists
if ! [ -d "${HOME}/.local/share/feral-interactive/XCOM/XEW" ]; then
	echo "ERROR: Cannot find directory '${HOME}/.local/share/feral-interactive/XCOM/XEW'"
	exit 1
fi


## install config files
for source_path in "${source_root}/Config"/*.ini; do
	## extract file name
	target_file="${source_path##*/}"

	## convert to lowercase
	target_file="${target_file,,}"

	## actually do the copy
	cp -v "${source_path}" "${target_root}/xew/xcomgame/config/${target_file}"
done


## install a few special config files in another place too!
cp -v "${source_root}/Config/DefaultContent.ini"  "${HOME}/.local/share/feral-interactive/XCOM/XEW/WritableFiles/XComContent.ini"
cp -v "${source_root}/Config/DefaultGameCore.ini" "${HOME}/.local/share/feral-interactive/XCOM/XEW/WritableFiles/XComGameCore.ini"
cp -v "${source_root}/Config/DefaultGameData.ini" "${HOME}/.local/share/feral-interactive/XCOM/XEW/WritableFiles/XComGameData.ini"
cp -v "${source_root}/Config/DefaultInput.ini"    "${HOME}/.local/share/feral-interactive/XCOM/XEW/WritableFiles/XComInput.ini"
cp -v "${source_root}/Config/DefaultLoadouts.ini" "${HOME}/.local/share/feral-interactive/XCOM/XEW/WritableFiles/XComLoadouts.ini"
cp -v "${source_root}/Config/DefaultMaps.ini"     "${HOME}/.local/share/feral-interactive/XCOM/XEW/WritableFiles/XComMaps.ini"


## install upk files
for source_path in "${source_root}/CookedPCConsole"/*.upk; do
	## extract file name
	target_file="${source_path##*/}"

	## convert to lowercase
	target_file="${target_file,,}"

	## actually do the copy
	cp -v "${source_path}" "${target_root}/xew/xcomgame/cookedpcconsole/${target_file}"
done


## install u files
for source_path in "${source_root}/CookedPCConsole"/*.u; do
	## extract file name
	target_file="${source_path##*/}"

	## convert to lowercase
	target_file="${target_file,,}"

	## actually do the copy
	cp -v "${source_path}" "${target_root}/xew/xcomgame/cookedpcconsole/${target_file}"
done


## install localization files
for source_path in "${source_root}/Localization/INT"/*.int; do
	## extract file name
	target_file="${source_path##*/}"

	## convert to lowercase
	target_file="${target_file,,}"

	## actually do the copy
	cp -v "${source_path}" "${target_root}/xew/xcomgame/localization/int/${target_file}"
	cp -v "${source_path}" "${target_root}/xew/binaries/share/feraloverrides/${target_file}"
done
